MERGE s61.sync_timestamps AS t
USING (SELECT 'table31' AS [source], 'table32' AS [target], COALESCE(MAX(ts), 0x) AS ts FROM s61.table31) AS s ([source], [target], ts)
ON (t.[source] = s.[source] AND t.[target] = s.[target])
WHEN MATCHED AND t.prev_ts = t.last_ts THEN
    UPDATE SET last_ts = s.ts
WHEN NOT MATCHED THEN  
    INSERT ([source], [target], last_ts) VALUES (s.[source], s.[target], s.ts);
